# -*- coding: utf-8 -*-

from django.conf import settings
from mysite.authorize_fun import check_push_device, get_cache 
from ooredis.client  import get_client

def check_authorize_fun():
    check_push_device(0, settings.AUTHORIZE_MAGIC_KEY)
    zkeco_count = get_cache("ZKECO_DEVICE_LIMIT")
    zktime_count = get_cache("ATT_DEVICE_LIMIT")
    zkpos_count = get_cache("POS_DEVICE_LIMIT")
    zkaccess_length = get_cache("MAX_ACPANEL_COUNT")
    
    r_client = get_client()
    att_count = len(r_client.keys("device:*:data"))
    pos_count = len(r_client.keys("pos_device:*:data"))
    all_dev_count = att_count + pos_count
#    print att_count, pos_count, all_dev_count, '--', zktime_count, zkpos_count, zkeco_count, zkaccess_length 
    if (att_count < zktime_count) or (pos_count < zkpos_count) or (all_dev_count<zkeco_count):
        return True
    else:
        return False

